CREATE OR REPLACE procedure fileannot is
    /* 36. Example: File annotation */
    
  l_blob blob;
  l_blob2 blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Get file from STORE_BLOB */
    select x.blob_file
      into l_blob2
     from store_blob x
     where rownum < 2;

   
   /* Add File annotation to the current page. */
   plpdf.AddFileAnnot(
     p_name => 'Paperclip',       -- The name of an icon to be used in displaying the annotation.
     p_contents => 'Oracle Database 10g has unique security features that ' || 
                   'address requirements in the areas of privacy, ' || 
                   'regulatory compliance, and data consolidation, ' || 
                   'including row-level security, fine grained auditing, ' || 
                   'and transparent data encryption.', 
                   /* The text to be displayed in the pop-up window when the 
                      annotation is opened. */
     p_x => 20,                   -- X coordinate of the annotation
     p_y => 20,                   -- Y coordinate of the annotation
     p_filename => '1.pdf',       -- name of file
     p_fileblob => l_blob2,       -- BLOB containing the PDF as binary data
     p_label => 'Industry-Leading Security', 
                  /* The text label to be displayed in the title bar of the 
                     annotations pop-up window when open and active. */
     p_color => plpdf_const.Lime  -- This color will be used.(see User Guide)
     );

    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
