CREATE OR REPLACE procedure textannot is
    /* 35. Example: Text annotation */
    
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 

    
    
    /* 1st annotation */
    
    /* Add Text annotation to the current page. */
    plpdf.AddTextAnnot(
      p_name => 'Note',     -- The name of an icon to be used in displaying the annotation.
      p_contents => 'With Oracle Enterprise Manager 10g Release 2, ' || 
                    'customers can manage many business applications, ' ||
                    'end-user services and the entire grid infrastructure ' || 
                    'as easily as managing one application running on one computer.', 
                    /* The text to be displayed in the pop-up window when the annotation is opened. */
      p_x => 20,            -- X coordinate of the annotation
      p_y => 30             -- Y coordinate of the annotation
      );

    
    
    /* 2nd annotation */
    
    /* Add Text annotation to the current page. */
    plpdf.AddTextAnnot(
      p_name => 'Key',      -- The name of an icon to be used in displaying the annotation.
      p_contents => 'Manage your grids as a single entity using improved ' || 
                    'tools such as new service modeling, broader support ' || 
                    'for service protocols, and comprehensive policies and templates. ' || 
                    'Virtualized application component resources, ' || 
                    'as well as virtualized infrastructure components, ' || 
                    'are transparently monitored, diagnosed, and provisioned.',
                    /* The text to be displayed in the pop-up window when the annotation is opened. */
      p_x => 20,            -- X coordinate of the annotation
      p_y => 50,            -- Y coordinate of the annotation
      p_label => 'Manage Virtualized Grid Resources', 
                    /* The text label to be displayed in the title bar 
                       of the annotations pop-up window when open and active. */
      p_popup_x  => 40,     -- X coordinate of the pop-up window
      p_popup_y  => 50,     -- Y coordinate of the pop-up window
      p_popup_w  => 100,    -- Width of the pop-up window
      p_popup_h  => 50      -- Height of the pop-up window
      );



    /* 3rd annotation */

    /* Add Text annotation to the current page. */
    plpdf.AddTextAnnot(
      p_name => 'Comment',  -- The name of an icon to be used in displaying the annotation.
      p_contents => 'Unique service management features such as graphical ' || 
                    'service topologies and service dashboards provide the ' || 
                    'right information to high-level decision makers and lines ' || 
                    'of business managers so they can better understand system ' ||
                    'and service level quality and plan effectively. ' || '
                    Robust automated provisioning and patching functionality ' || 
                    'give IT administrators the power make efficient, error-free changes.',
                    /* The text to be displayed in the pop-up window when the annotation is opened. */
      p_x => 20,            -- X coordinate of the annotation
      p_y => 70,            -- Y coordinate of the annotation
      p_label => 'Best Quality of Service at Lowest Management Cost',
                    /* The text label to be displayed in the title bar 
                       of the annotations pop-up window when open and active. */
      p_color => plpdf_const.Lime, -- This color will be used.(see User Guide)
      p_popup_x  => 40,     -- X coordinate of the pop-up window
      p_popup_y  => 70,     -- X coordinate of the pop-up window
      p_popup_w  => 140,    -- Width of the pop-up window
      p_popup_h  => 50      -- Height of the pop-up window
      );

    
    
    /* 4th annotation */
    
    /* Add Text annotation to the current page. */
    plpdf.AddTextAnnot(
      p_name => 'Help',     -- The name of an icon to be used in displaying the annotation.
      p_contents => 'Increased management scope for IT infrastructure products ' || 
                    'provide customers improved insight into every aspect of ' || 
                    'service performance  including application servers, ' || 
                    'firewalls, operating systems, load balancers, ' || 
                    'and storage components. Customers can easily detect and ' || 
                    'resolve issues throughout a grid as well as monitor and ' || 
                    'manage key non-Oracle products in the data center environment.',
                    /* The text to be displayed in the pop-up window when the annotation is opened. */
      p_x => 20,            -- X coordinate of the annotation
      p_y => 90,            -- X coordinate of the annotation
      p_label => 'Higher Value through Wider Breadth of Management',
                    /* The text label to be displayed in the title bar 
                       of the annotations pop-up window when open and active. */
      p_color => plpdf_const.Salmon,  -- This color will be used.(see User Guide)
      p_popup_x  => 40,     -- X coordinate of the pop-up window
      p_popup_y  => 90,     -- X coordinate of the pop-up window
      p_popup_w  => 140,    -- Width of the pop-up window
      p_popup_h  => 50,     -- Height of the pop-up window
      p_open => true        -- A flag specifying whether the pop-up window should initially be displayed open.
      );

    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob       -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
