CREATE OR REPLACE procedure protect is
    /* 27. Example: Protection */
 
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Allows to protect the PDF document. */
    plpdf.SetProtection(
     p_print_perm => true,          -- Print the PDF
     p_modify_perm => true,         -- Modify the PDF
     p_copy_perm => true,           -- Copy the PDF
     p_annot_forms_perm => true,    -- Add annotations and forms
     p_user_pass => 'apple',        -- User password
     p_owner_pass=> 'pear'          -- Owner password
     );
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
     
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',           -- Font family: Arial
     p_style => null,               -- Font style: regular (default)
     p_size => 12                   -- Font size: 12 pt
     ); 
     
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 65,                     -- Rectangle width
     p_h => 10,                     -- Rectangle heigth
     p_txt => 'Protection example'  -- Text in rectangle 
     ); 
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
