CREATE OR REPLACE procedure clipping is
/* 26. Example: Clipping */
   --------------- 
  l_blob blob;
  l_text varchar2(255) := 'Hello World! Hello World! Hello World!';
  l_length number;
 begin
   
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',       -- Font family: Arial
     p_style => null,           -- Font style: regular (default)
     p_size => 12               -- Font size: 12 pt
     ); 
    
     /* function plpdf.GetTextWidth: 
       Returns the width of the parameter text. 
       The width of the text in the unit of measure specified in plpdf.Init */
    l_length := plpdf.GetTextWidth(
                 p_s => l_text  -- Parameter text
                 );
    
    /* Starts a clipping frame. 
       The clipping limits the region that can be paint. */
    plpdf.StartClipping(
    p_x => 20,                  -- X coordinate for the start of the clipping frame
    p_y => 15,                  -- Y coordinate for the start of the clipping frame
    p_w => 40,                  -- Height of clipping frame
    p_h => 50                   -- Width of clipping frame
    );
    
    for l_i in 1..6 loop
      /* Draws a rectangle cell with text inside. */
      plpdf.PrintCell(
       p_w => l_length,         -- Rectangle width
       p_h => 10,               -- Rectangle heigth
       p_txt => l_text,         -- Text in rectangle 
       p_border => '1',         -- With frame
       p_ln => 1,                -- Cursor position after the cell is printed: New line  
	   p_clipping => 0			-- no clipping
       );    
    end loop;
    
    /* The clipping affects for objects wich located between
       StartClipping and EndClipping. */
    plpdf.EndClipping;
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
