CREATE OR REPLACE procedure ttfembending is
    /* 25. Example: TTF embending */
 
  l_blob blob;
  l_ttf Plpdf_Type.t_addfont;
 begin
    
    /* Retrieves the font form PLPDF_TTF_ADD table.*/
    l_ttf := plpdf_Ttf.GetTTF(
              p_id => 1  -- ID field of the PLPDF_TTF_ADD table
              );
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init;
    
    /* Imports a TTF (True Type Font). The imported font becomes
       available to the SetPrintFont procedure. */
    Plpdf.addTTF(
     p_family => 'ArialMT',  -- TTF name
     p_style => null,  -- Font style: Regular
     p_data => l_ttf  -- It contains the font definition binary file
     );
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'ArialMT',    -- Font family: ArialMT
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     );
    
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,              -- Rectangle width
     p_h => 10,              -- Rectangle heigth
     p_txt => 'TTF Example' -- Text in rectangle 
     ); 
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
