CREATE OR REPLACE procedure drawsector is
    /* 24. Example: Draw sector */
    
  l_blob  blob;
  l_xc    number;
  l_yc    number;
  l_r     number; 
 begin
   
   /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    l_xc := 105;    -- Abscissa of the center
    l_yc := 55;     -- Ordinate of the center
    l_r := 40;      -- Radius
    
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 120,    -- Red component code, can be between 0 and 255
     p_g => 120,    -- Green component code, can be between 0 and 255
     p_b => 255     -- Blue component code, can be between 0 and 255
     );
     
    /* Draws a sector on the current page. */
    plpdf.DrawSector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 20,     -- Starting point of the sector
     p_b => 120     -- End point of the sector
     ); 
    
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 120,    -- Red component code, can be between 0 and 255
     p_g => 255,    -- Green component code, can be between 0 and 255
     p_b => 120     -- Blue component code, can be between 0 and 255
     );
    
    /* Draws a sector on the current page. */
    plpdf.DrawSector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 120,    -- Starting point of the sector
     p_b => 250     -- End point of the sector
     ); 
    
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 255,    -- Red component code, can be between 0 and 255
     p_g => 120,    -- Green component code, can be between 0 and 255
     p_b => 120     -- Blue component code, can be between 0 and 255
     );
    
    /* Draws a sector on the current page. */
    plpdf.DrawSector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 250,    -- Starting point of the sector
     p_b => 20      --End point of the sector
     ); 
  
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

