CREATE OR REPLACE procedure bookmark is
    /* 23. Example: Bookmark */
  
  l_blob blob;
 begin
   /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',       -- Font family: Arial
     p_style => null,           -- Font style: regular (default)
     p_size => 12               -- Font size: 12 pt
     ); 
	
    /* Create a bookmark in the PDF document. 
       Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
    plpdf.CrBookmark(
     p_txt => 'Page 1',         -- Text of bookmark
     p_level => 0,              -- Bookmark level
     p_y => -1                  -- Y coordinate of the bookmark within the current page: denoted 
     );
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                 -- Rectangle width
     p_h => 10,                 -- Rectangle heigth
     p_txt => 'Page 1'          -- Text in rectangle 
     ); 
	
    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 20                  -- Height of the line break.
     );
     
    /* Create a bookmark in the PDF document. 
       Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
    plpdf.CrBookmark(
     p_txt => 'Paragraph 1.1',  -- Text of bookmark
     p_level => 1,              -- Bookmark level
     p_y => -1                  -- Y coordinate of the bookmark within the current page. 1 denotes the cursor position.
     );	
  	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                 -- Rectangle width
     p_h => 10,                 -- Rectangle heigth
     p_txt => 'Paragraph 1.1'   -- Text in rectangle 
     ); 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage;
    
    /* Create a bookmark in the PDF document. 
       Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
    plpdf.CrBookmark(
     p_txt => 'Page 2',         -- Text of bookmark
     p_level => 0,              -- Bookmark level
     p_y => -1                  -- Y coordinate of the bookmark within the current page: denoted
     );	
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                 -- Rectangle width
     p_h => 10,                 -- Rectangle heigth
     p_txt => 'Page 2'          -- Text in rectangle 
     ); 
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob           -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

