CREATE OR REPLACE procedure image is
    /* 20. Example:  Image */
  
  l_blob blob;
  l_image blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
     
    /* Begin a new page.
       If no orientation is given then the orientation 
       specified in Init will be used. (landscape) */
    plpdf.NewPage;
     
    /* Select image from a table.
       Needs table IMAGE_BLOB(id number, image_file blob).
       Image_file must contain image. */
    select image_file
      into l_image
     from IMAGE_BLOB
     where id = 1
     for update;
    
    
    /* Inserts an image (JPG, BMP, PNG, etc.) from a BLOB variable
       into the current page. */
    plpdf.PutImage(
     p_name => 'tst_160_80.jpg',  -- Image name or ID
     p_data => l_image,           -- Variable containing the image as binary data
     p_x => 10,                   -- X coordinate of the image
     p_y => 20,                   -- Y coordinate of the image
     p_w => 80,                   -- Image width
     p_h =>  40                   -- Image height
     );    
   
   
    /* Inserts an image (JPG, BMP, PNG, etc.) from a BLOB variable
       into the current page. */
    plpdf.PutImage(
     p_name => 'tst.jpg',         -- Image name or ID
     p_data => l_image,           -- Variable containing the image as binary d
     p_x => 10,                   -- X coordinate of the image
     p_y => 70,                   -- Y coordinate of the image
     p_w =>  0,                   -- Image width, if 0 then the image is displayed in its actual width
     p_h =>  0                    -- Image height, if 0 then the image is displayed in its actual height
     );
	
        
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob             -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

