CREATE OR REPLACE procedure multilinecell is
/* 17. Example:  Multiline cell */
  
  l_blob blob;
  l_link number;
 begin
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     ); 
     
    /* Draws a multi line cell. Default values: 
     - border: 0: without border, 
     - alignment: J: froce justification, 
     - fill: 0: no fill, 
     - maxline: 0: no max */
    plpdf.PrintMultiLineCell(
     p_w => 50, -- Rectangle width
     p_h => 10, -- Rectangle height
     p_txt => 'Generate dynamic PDF documents from data stored in Oracle databases using the PL/PDF program package.' -- Text in rectangle
     );
			 
    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 20                          --Height of the line break.
     );

    /* Draws a multi line cell. Default values: 
     - fill: 0: no fill, 
     - maxline: 0: no max */
    plpdf.PrintMultiLineCell(
     p_w => 50, -- Rectangle width
     p_h => 10, -- Rectangle height
     p_txt => 'Generate dynamic PDF documents from data stored in Oracle databases using the PL/PDF program package.', -- Text in rectangle
     p_border => '1',  -- Rectangle border: outline border
     p_align => 'L'    -- Text alignment: Left
     );
	      
				  	
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

