CREATE OR REPLACE procedure interlink is
    /* 16. Example: Internal link */
    
  l_blob blob;
  l_link number;
 begin
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Creates an internal link, and returns its ID. 
       An internal link can be used to take the cursor to another place 
       within the document by clicking over it. */
    l_link := plpdf.CrInternalLink;
	
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',   -- Font family: Arial
     p_style => null,       -- Font style: regular (default)
     p_size => 12           -- Font size: 12 pt
     ); 
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,             -- Rectangle width
     p_h => 10,             -- Rectangle heigth
     p_txt => 'Start Point' -- Text in rectangle 
     ); 
    
    /* Sets the destination page and position for the internal link */
    plpdf.SetLinkDest(l_link); 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Puts a link area on the page that point to an internal link */
    plpdf.PutLink(
     p_x => 50,               --X coordinate of the top left corner of the area
     p_y => 50,               -- Y coordinate of the top left corner of the area
     p_w => 50,               -- Link area width
     p_h => 10,               -- Link area height
     p_link => l_link         -- Internal link ID
     );
	
    /* Draws a rectangle on the page */  	
    plpdf.DrawRect(
     p_x => 50,               -- X coordinate for the top left corner of the rectangle
     p_y => 50,               -- Y coordinate for the top left corner of the rectangle
     p_w => 50,               -- The width of the rectangle
     p_h => 10,               -- The height of the rectangle
     p_style => 'D'           -- Style: no fill, border line
     );
        
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob         -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

