CREATE OR REPLACE procedure drawline is
    /* 14. Example: Draw line */
  
  l_blob blob;
 begin
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 10,        -- X coordinate for the start of the line
     p_y1 => 10,        -- Y coordinate for the start of the line
     p_x2 => 10,        -- X coordinate for the end of the line
     p_y2 => 30         -- Y coordinate for the end of the line
     ); 
	
    /* Sets the line color for objects (line, rectangle, circle etc.) 
       inserted after this statement. */
    plpdf.SetColor4Drawing(
     p_r => 220,        -- Red component code, can be between 0 and 255
     p_g => 50,         -- Green component code, can be between 0 and 255
     p_b => 50          -- Blue component code, can be between 0 and 255
     ); 
	
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 20,        -- X coordinate for the start of the line
     p_y1 => 10,        -- Y coordinate for the start of the line
     p_x2 => 20,        -- X coordinate for the end of the line
     p_y2 => 30         -- Y coordinate for the end of the line
     ); 
       
    /* Sets the line color for objects (line, rectangle, circle etc.) 
       inserted after this statement. 
     - r_g: -1 (default)
     - r_b: -1 (default) */
    plpdf.SetColor4Drawing(
     p_r => 0           -- Red component code: 0 (black)
     ); 
        
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 30,        -- X coordinate for the start of the line
     p_y1 => 10,        -- Y coordinate for the start of the line
     p_x2 => 30,        -- X coordinate for the end of the line
     p_y2 => 30         -- Y coordinate for the end of the line
     ); 

    /* Sets the thickness of lines drawn after this statement. If
      no thickness is set then it is 0.2 mm by default. */
    plpdf.SetLineWidth(
     p_width => 0.4     -- Line width: 0.4 mm
     ); 
	
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 40,        -- X coordinate for the start of the line
     p_y1 => 10,        -- Y coordinate for the start of the line
     p_x2 => 40,        -- X coordinate for the end of the line
     p_y2 => 30         -- Y coordinate for the end of the line
     ); 
	
    /* Sets the line color for objects (line, rectangle, circle etc.) 
       inserted after this statement. */
    plpdf.SetColor4Drawing(
     p_r => 200,        -- Red component code, can be between 0 and 255
     p_g => 220,        -- Green component code, can be between 0 and 255
     p_b => 255         -- Blue component code, can be between 0 and 255
     ); 
        
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 50,        -- X coordinate for the start of the line
     p_y1 => 10,        -- Y coordinate for the start of the line
     p_x2 => 50,        -- X coordinate for the end of the line
     p_y2 => 30         -- Y coordinate for the end of the line
     ); 
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob   -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

