CREATE OR REPLACE procedure docprop is
    /* 10. Example: Set document properties*/
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Sets the document title. */
    plpdf.SetDocTitle(
     p_title => 'Document title' -- Document title
     ); 

    /* Sets the document subject. */	
    plpdf.SetDocSubject(
    p_subject => 'Document subject' -- Document subject
    ); 
	
    /* Sets the document author */
    plpdf.SetDocAuthor(
     p_author => 'Document author' -- Document author
     );
	
    /*Sets the document keywords*/
        plpdf.SetDocKeywords(
        p_keywords => 'key1, key2, key3' -- Keyword list
        ); 
        
    /* Sets the document creator */        
        plpdf.SetDocCreator(
        p_creator => 'Document creator' -- Document creator
        ); 
     /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     );    
   
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 80,              -- Rectangle width
     p_h => 10,              -- Rectangle heigth
     p_txt => 'Document properties example' -- Text in rectangle 
     ); 
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob  -- The generated document
     );
    
    
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

