CREATE OR REPLACE procedure setmargins is
    /* 8. Example: Set Margins */
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init;
    
    /* Sets the margin size. */
    plpdf.SetAllMargin(
     p_left => 20, -- Left margin: 20mm
     p_top => 25,  -- Top margin: 25mm
     p_right => 30 -- Right margin: 30mm
     ); 
    
    /* begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial', -- Font family: Arial
     p_style => null,     -- Font style: regular (default)
     p_size => 12         -- Font size: 12 pt
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,              -- Rectangle width
     p_h => 10,              -- Rectangle heigth
     p_txt => 'Set margins example' -- Text in rectangle 
     ); 
     
    /* Returns the generated PDF document. 
        The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob  -- The generated document
     );
    
    
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

