CREATE OR REPLACE procedure headerfooter is
    /* 7. Example:  Header, Footer, number of pages */
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
	    
    /* Defines the page number alias. 
       Default: {nb} */    
    plpdf.nopAlias;

    /*Sets the page header procedure name. The program name passed 
      as a parameter executes when the page header is created. */
    plpdf.SetHeaderProcName(
     p_proc_name => 'xheader',    -- Page header procedure name: xheader
     p_height => 10               -- Height of header section
     );
    
    /* Sets the page footer procedure name. The program name passed
       as a parameter executes when the page footer is created. */
    plpdf.SetFooterProcName(
     p_proc_name => 'xfooter',    --Page footer procedure name: xfooter
     p_height => 10               --Height of footer section
     ); 
     
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     ); 
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,              -- Rectangle width
     p_h => 10,              -- Rectangle heigth
     p_txt => 'Page 1'       -- Text in rectangle 
     ); 
	
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,              -- Rectangle width
     p_h => 10,              -- Rectangle heigth
     p_txt => 'Page 2'       -- Text in rectangle 
     ); 
     
    /* Returns the generated PDF document. 
        The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob  -- The generated document
     );
    
    
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

