CREATE OR REPLACE procedure encoding is
    /* 6. Example : Encoding */
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init;
    
    /* Sets Adobe Core character encoding (default code is cp1252)
       or Unicode TTF embending (AL32UTF8 database) with utf16. */
    plpdf.SetEncoding(
     p_enc => 'cp1250'           -- Set encoding: cp1250
     ); 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: regular (default)
     p_size => 12                -- Font size: 12 pt
     ); 
    
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 100,                 -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => UNISTR('\0171\00ED\00E9\00E1\0151\00FA\00F6\00FC\00F3!')       -- Text in rectangle
     ); 
    
    /* Returns the generated PDF document. 
        The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob            -- The generated document
     );
    
    
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

