CREATE OR REPLACE procedure printcell is
    /* 5. Example: Using PrintCell */
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial', -- Font family: Arial
     p_style => null,     -- Font style: regular (default)
     p_size => 12         -- Font size: 12 pt
     ); 
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                -- Rectangle width
     p_h => 10,                -- Rectangle heigth
     p_txt => 'Without frame', -- Text in rectangle 
     p_border => '0'           -- Without frame
     ); 
	
    /* Draws a rectangle cell with text inside. */    
    plpdf.PrintCell(
     p_w => 50,                -- Rectangle width
     p_h => 10,                -- Rectangle heigth
     p_txt => 'With frame',    -- Text in rectangle 
     p_border => '1'           -- With frame
     );    
        
    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 20                 -- Height of the line break.
     );
        
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'New line',               -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1'                        -- Cursor position after the cell is printed: New line  
     );    	
        
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Beside the cell',        -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '0'                        -- Cursor position after the cell is printed: Beside the cell  
     );       
     
    /* Line break. 
       Cursor is placed at the start of the next line. */
    plpdf.LineBreak(
     p_h => 20 --Height of the line break.
     );
	
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Left',                   -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'L'                     -- Text alignment: Left
     );   	
        
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Right',                  -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'R'                     -- Text alignment: Right
     );   	      
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Center',                 -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'C'                     -- Text alignment: Center
     );   	  
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Force Justification',    -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'J'                     -- Text alignment: Force justification
     );   	  
        
    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 20                           --Height of the line break.
     );
     
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 200, -- Red component code, can be between 0 and 255
     p_g => 220, -- Green component code, can be between 0 and 255
     p_b => 255  -- Blue component code, can be between 0 and 255
     ); 

    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Filled',                 -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'L',                    -- Text alignment: Left
     p_fill => 1                        -- Fill with current fill color
     );   	  


    /* Draws a rectangle cell with text inside. */	
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'No Fill',                -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'L',                    -- Text alignment: Left
     p_fill => 0                        -- No fill
     );   	    
     	
    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 20                          --Height of the line break.
     );

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => 'U',                    -- Font style: Underline
     p_size => 12                        -- Font size: 12 pt
     );

    /* Draws a rectangle cell with text inside. */	   
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Link',                   -- Text in rectangle 
     p_border => '1',                   -- With frame
     p_ln => '1',                       -- Cursor position after the cell is printed: new line  
     p_align => 'L',                    -- Text alignment: Left
     p_fill => 0,                       -- No fill
     p_link => 'http://www.google.com'  -- Link related to the text, can be a URL or an internal link ID
     );   	    
     	
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob  -- The generated document
     );
    
    
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

