CREATE OR REPLACE procedure size_a3 is
    /* 3. Example: page size A3 */
  
  l_blob blob;
 begin
    
    /* Initializes generator program variables */
    plpdf.init(
     p_orientation => 'P', --Page orientation: Portrait
     p_unit => 'mm',       --Unit of measure: milimeter
     p_format => 'A3'      --Default page format: A3
     ); 
    
    /*Begin a new page*/
    plpdf.NewPage;
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial', -- Font family: Arial
     p_style => null,     -- Font style: regular (default)
     p_size => 12         -- Font size: 12 pt
     );
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Size A3 Example'   -- Text in rectangle 
     ); 
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob  -- The generated document
     );
	
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

