/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.BerOctetStringGenerator;
import org.bouncycastle.sasn1.BerSequenceGenerator;

public class CMSEnvelopedDataStreamGenerator {
    public static final String DES_EDE3_CBC = "1.2.840.113549.3.7";
    public static final String RC2_CBC = "1.2.840.113549.3.2";
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    SecureRandom rand = new SecureRandom();
    List recipientInfs = new ArrayList();
    private Object _originatorInfo = null;
    private Object _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(x509Certificate));
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(publicKey, (ASN1OctetString)new DEROctetString(byArray)));
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(secretKey, new KEKIdentifier(byArray, null, null)));
    }

    public void setBerEncodeRecipients(boolean bl) {
        this._berEncodeRecipientSet = bl;
    }

    private Asn1Integer getVersion() {
        if (this._originatorInfo != null || this._unprotectedAttributes != null) {
            return new Asn1Integer(2L);
        }
        return new Asn1Integer(0L);
    }

    private OutputStream open(OutputStream outputStream, String string, KeyGenerator keyGenerator, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        AlgorithmParameters algorithmParameters;
        Object object;
        Object object2;
        SecretKey secretKey = keyGenerator.generateKey();
        try {
            object2 = AlgorithmParameterGenerator.getInstance(string, string2);
            if (string.equals(RC2_CBC)) {
                object = new byte[8];
                this.rand.setSeed(System.currentTimeMillis());
                this.rand.nextBytes((byte[])object);
                try {
                    ((AlgorithmParameterGenerator)object2).init(new RC2ParameterSpec(secretKey.getEncoded().length * 8, (byte[])object));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new CMSException("parameters generation error: " + invalidAlgorithmParameterException, invalidAlgorithmParameterException);
                }
            }
            algorithmParameters = ((AlgorithmParameterGenerator)object2).generateParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            algorithmParameters = null;
        }
        object2 = this.recipientInfs.iterator();
        object = new ASN1EncodableVector();
        while (object2.hasNext()) {
            RecipientInf recipientInf = (RecipientInf)object2.next();
            try {
                object.add((DEREncodable)recipientInf.toRecipientInfo(secretKey, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        return this.open(outputStream, string, secretKey, algorithmParameters, (ASN1EncodableVector)object, string2);
    }

    protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameters algorithmParameters, ASN1EncodableVector aSN1EncodableVector, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        try {
            AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(string, algorithmParameters);
            BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(outputStream);
            berSequenceGenerator.addObject(new Asn1ObjectIdentifier(CMSObjectIdentifiers.envelopedData.getId()));
            BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(berSequenceGenerator.getRawOutputStream(), 0, true);
            berSequenceGenerator2.addObject(this.getVersion());
            if (this._berEncodeRecipientSet) {
                berSequenceGenerator2.getRawOutputStream().write(new BERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            } else {
                berSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            }
            Cipher cipher = Cipher.getInstance(string, string2);
            cipher.init(1, (Key)secretKey, algorithmParameters);
            BerSequenceGenerator berSequenceGenerator3 = new BerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
            berSequenceGenerator3.addObject(new Asn1ObjectIdentifier(PKCSObjectIdentifiers.data.getId()));
            berSequenceGenerator3.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(berSequenceGenerator3.getRawOutputStream(), 0, false);
            CipherOutputStream cipherOutputStream = this._bufferSize != 0 ? new CipherOutputStream(berOctetStringGenerator.getOctetOutputStream(new byte[this._bufferSize]), cipher) : new CipherOutputStream(berOctetStringGenerator.getOctetOutputStream(), cipher);
            return new CmsEnvelopedDataOutputStream(cipherOutputStream, berSequenceGenerator, berSequenceGenerator2, berSequenceGenerator3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(String string, AlgorithmParameters algorithmParameters) throws IOException {
        DERNull dERNull;
        ByteArrayInputStream byteArrayInputStream;
        if (algorithmParameters != null) {
            byteArrayInputStream = new ByteArrayInputStream(algorithmParameters.getEncoded("ASN.1"));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            dERNull = aSN1InputStream.readObject();
        } else {
            dERNull = new DERNull();
        }
        byteArrayInputStream = new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)dERNull);
        return byteArrayInputStream;
    }

    public OutputStream open(OutputStream outputStream, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string, string2);
            return this.open(outputStream, string, keyGenerator, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find key generation algorithm.", noSuchAlgorithmException);
        }
    }

    public OutputStream open(OutputStream outputStream, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string, string2);
            keyGenerator.init(n);
            return this.open(outputStream, string, keyGenerator, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find key generation algorithm.", noSuchAlgorithmException);
        }
    }

    private class CmsEnvelopedDataOutputStream
    extends OutputStream {
        private CipherOutputStream _out;
        private BerSequenceGenerator _cGen;
        private BerSequenceGenerator _envGen;
        private BerSequenceGenerator _eiGen;

        public CmsEnvelopedDataOutputStream(CipherOutputStream cipherOutputStream, BerSequenceGenerator berSequenceGenerator, BerSequenceGenerator berSequenceGenerator2, BerSequenceGenerator berSequenceGenerator3) {
            this._out = cipherOutputStream;
            this._cGen = berSequenceGenerator;
            this._envGen = berSequenceGenerator2;
            this._eiGen = berSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._envGen.close();
            this._cGen.close();
        }
    }

    private class RecipientInf {
        X509Certificate cert;
        AlgorithmIdentifier keyEncAlg;
        PublicKey pubKey;
        ASN1OctetString subKeyId;
        SecretKey secKey;
        KEKIdentifier secKeyId;

        RecipientInf(X509Certificate x509Certificate) {
            this.cert = x509Certificate;
            this.pubKey = x509Certificate.getPublicKey();
            try {
                byte[] byArray = x509Certificate.getTBSCertificate();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
                TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
                SubjectPublicKeyInfo subjectPublicKeyInfo = tBSCertificateStructure.getSubjectPublicKeyInfo();
                this.keyEncAlg = subjectPublicKeyInfo.getAlgorithmId();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't extract key algorithm from this cert");
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("can't extract tbs structure from this cert");
            }
        }

        RecipientInf(PublicKey publicKey, ASN1OctetString aSN1OctetString) {
            this.pubKey = publicKey;
            this.subKeyId = aSN1OctetString;
            try {
                byte[] byArray = publicKey.getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream.readObject());
                this.keyEncAlg = subjectPublicKeyInfo.getAlgorithmId();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't extract key algorithm from this key");
            }
        }

        RecipientInf(SecretKey secretKey, KEKIdentifier kEKIdentifier) {
            this.secKey = secretKey;
            this.secKeyId = kEKIdentifier;
            if (secretKey.getAlgorithm().startsWith("DES")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (DEREncodable)new DERNull());
            } else if (secretKey.getAlgorithm().startsWith("RC2")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (DEREncodable)new DERInteger(58));
            } else if (secretKey.getAlgorithm().startsWith("AES")) {
                int n = secretKey.getEncoded().length * 8;
                DERObjectIdentifier dERObjectIdentifier = null;
                if (n == 128) {
                    dERObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
                } else if (n == 192) {
                    dERObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
                } else if (n == 256) {
                    dERObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
                } else {
                    throw new IllegalArgumentException("illegal keysize in AES");
                }
                this.keyEncAlg = new AlgorithmIdentifier(dERObjectIdentifier, (DEREncodable)new DERNull());
            } else {
                throw new IllegalArgumentException("unknown algorithm");
            }
        }

        RecipientInfo toRecipientInfo(SecretKey secretKey, String string) throws IOException, GeneralSecurityException {
            Cipher cipher = Cipher.getInstance(this.keyEncAlg.getObjectId().getId(), string);
            if (this.pubKey != null) {
                byte[] byArray = secretKey.getEncoded();
                cipher.init(1, this.pubKey);
                DEROctetString dEROctetString = new DEROctetString(cipher.doFinal(byArray));
                if (this.cert != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cert.getTBSCertificate());
                    ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
                    TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
                    IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
                    return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(issuerAndSerialNumber), this.keyEncAlg, (ASN1OctetString)dEROctetString));
                }
                return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(this.subKeyId), this.keyEncAlg, (ASN1OctetString)dEROctetString));
            }
            cipher.init(3, this.secKey);
            DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
            return new RecipientInfo(new KEKRecipientInfo(this.secKeyId, this.keyEncAlg, (ASN1OctetString)dEROctetString));
        }
    }
}

