/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.digsig;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class BCSign {
    private BCSign() {
    }

    public static String PKCS7Sign(BLOB inputFile, BLOB outputFile, BLOB keystore, CHAR certAlias, CHAR keystorePassword, CHAR privatekeyPassword) {
        try {
            int nRead;
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream keystore_inputStream = null;
            if (inputFile != null) {
                keystore_inputStream = keystore.getBinaryStream();
            }
            String certAlias_string = certAlias != null ? certAlias.getString() : "";
            String keystorePassword_string = keystorePassword != null ? keystorePassword.getString() : "";
            String privatekeyPassword_string = privatekeyPassword != null ? privatekeyPassword.getString() : keystorePassword_string;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            KeyStore ks = null;
            PrivateKey key = null;
            Certificate[] chain = null;
            Certificate storecert = null;
            ArrayList<Certificate> list = new ArrayList<Certificate>();
            CertStore chainStore = null;
            String alias = null;
            Security.addProvider((Provider)new BouncyCastleProvider());
            ks = KeyStore.getInstance("PKCS12");
            ks.load(keystore_inputStream, keystorePassword_string.toCharArray());
            alias = certAlias_string == "" ? ks.aliases().nextElement() : certAlias_string;
            key = (PrivateKey)ks.getKey(alias, privatekeyPassword_string.toCharArray());
            chain = ks.getCertificateChain(alias);
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            storecert = ks.getCertificate(alias);
            generator.addSigner(key, (X509Certificate)storecert, CMSSignedDataGenerator.DIGEST_SHA1);
            int i = 0;
            while (i < chain.length) {
                list.add(chain[i]);
                ++i;
            }
            chainStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(list), "BC");
            generator.addCertificatesAndCRLs(chainStore);
            CMSProcessableByteArray content = new CMSProcessableByteArray(buffer.toByteArray());
            CMSSignedData signedData = generator.generate((CMSProcessable)content, false, "BC");
            byte[] pk = signedData.getEncoded();
            outputStream.write(pk);
            outputStream.close();
        }
        catch (Throwable t) {
            return BCSign.getStackTraceString(t);
        }
        return null;
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

